attribute vec4 a_position;
attribute vec2 a_texCoord;

uniform vec2 u_offsetX;
uniform vec2 u_offsetY;
uniform vec2 u_gridUVSize;

varying vec2 v_texCoord;
varying vec2 v_neighbours[8];

void main()
{
    gl_Position = CC_MVPMatrix * a_position;
    v_texCoord = a_texCoord;
    vec2 scaleCoord = a_texCoord * u_gridUVSize;
    
    v_neighbours[0] = scaleCoord - u_offsetX;
    v_neighbours[1] = scaleCoord + u_offsetX;
    v_neighbours[2] = scaleCoord - u_offsetY;
    v_neighbours[3] = scaleCoord - u_offsetY + u_offsetX;
    v_neighbours[4] = scaleCoord - u_offsetY - u_offsetX;
    v_neighbours[5] = scaleCoord + u_offsetY;
    v_neighbours[6] = scaleCoord + u_offsetY + u_offsetX;
    v_neighbours[7] = scaleCoord + u_offsetY - u_offsetX;
    
    
}
